(function() {
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll) {
    var TimereportTravelExpenseView;
    return TimereportTravelExpenseView = (function() {
      class TimereportTravelExpenseView extends Backbone.View {
        initialize(usr, timereport, showOnlyTe) {
          var ref;
          this.usr = usr;
          this.timereport = timereport;
          this.showOnlyTe = showOnlyTe;
          this.timeFormat = parseInt(this.usr.get('usesAMPM'), 10) === 0 ? "HH:mm" : "hh:mm A";
          this.dateTimeFormat = 'YYYY-MM-DD ' + this.timeFormat;
          this.timereport.on('TravelExpenseVerified', this.__filled_timereport, this);
          this.timereport.on('change', this.__filled_timereport, this);
          this.defaultCurrency = (ref = _.findWhere(this.usr.get('TravelExpenseCurrencies'), {
            isDefault: 1
          })) != null ? ref.name : void 0;
          window.expense = {};
          return window.expense.previousAllowPerDiem = -1;
        }

        events() {
          return {
            //HEADER
            'tap .btn-travel-day': 'btnTravelDayClicked',
            'change .input-day-travel': 'travelDayChanged',
            'tap #id-btn-travel-day-next': 'btnTravelDayDoneClicked',
            'tap .time': 'btnTravelHeaderClicked',
            'tap .edit-note': 'btnEditNoteClicked',
            'tap #id-btn-done-note': 'btnDoneNoteClicked',
            'tap .edit-destination': 'btnEditDestinationClicked',
            'tap #id-btn-done-destination': 'btnDoneDestinationClicked',
            //DIEM
            'tap #id-btn-diem': 'btnDiemClicked',
            'tap #id-btn-abroad': 'btnAbroadClicked',
            'tap .btn-quantity': 'btnQuantityClicked',
            //DRIVE
            'tap #id-btn-new-drive': 'btnAddNewDrive',
            'tap #id-btn-save-drive': 'btnSaveDrive',
            'tap .trDrive': 'trDriveClicked',
            'tap #id-btn-drive-own-car': '__change_button_status',
            'tap #id-btn-delete-drive': 'btnDeleteDrive',
            //CASH
            'tap #id-btn-new-cash': 'btnAddNewCash',
            'tap #id-btn-save-cash': 'btnSaveCash',
            'tap .trCashAdvance': 'trCashAdvanceClicked',
            'tap #id-btn-cash-card': '__change_button_status',
            'tap #id-btn-delete-cash': 'btnDeleteCash',
            //EXPENSE
            'tap #id-btn-new-expense': 'btnAddNewExpense',
            'tap #id-btn-save-expense': 'btnSaveExpense',
            'tap .trExpense': 'trExpenseClicked',
            'tap #id-btn-expense-paid-card': '__change_button_status',
            'tap #id-btn-delete-expense': 'btnDeleteExpense',
            'change #id-input-file-expense': 'btnUploadImageExpense',
            'tap #id-a-thumbnail': 'btnThumbnailClicked',
            'tap #id-delete-thumbnail': 'btnDeleteThumbnailClicked',
            //ALL FORMS
            'tap .btn-cancel-form': 'btnCancelForm'
          };
        }

        render() {
          var template;
          template = Handlebars.templates['TimereportTravelExpenseView'];
          this.$el.html(template({
            currencies: this.usr.get('TravelExpenseCurrencies'),
            cashTypes: this.usr.get('TravelExpenseCashAdvanceTypes'),
            expenseTypes: this.usr.get('TravelExpenseExpenseTypes'),
            defaultCurrency: this.defaultCurrency
          }));
          if (this.timereport.get('Timereport')) {
            this.__filled_timereport();
          }
          this.$el.attr('id', 'divTimeReportTravel');
          if (!this.showOnlyTe) {
            this.$el.css('display', 'none');
          }
          return this.$el;
        }

        btnCancelForm(event) {
          var cur, target;
          event.stopPropagation();
          event.preventDefault();
          cur = $(event.currentTarget);
          target = cur.attr('data-target');
          this.$el.find(target).hide();
          window.expense['imageFileData'] = null;
          $('#id-btn-save-tr').show();
          return this.$el.find('#id-div-wrap-travel-expense').show();
        }

        btnTravelDayClicked(event) {
          var cur, input, options, type;
          event.stopPropagation();
          event.preventDefault();
          cur = $(event.currentTarget);
          type = cur.attr('data-type');
          if (type === 'in') {
            input = this.$el.find('#id-input-travel-day-in');
          } else {
            input = this.$el.find('#id-input-travel-day-out');
          }
          options = {
            theme: 'iOS',
            display: 'bottom',
            dateFormat: 'yy-mm-dd',
            dateOrder: 'ddmmyyyy',
            maxDate: window.MAXDATE
          };
          if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
            options['timeFormat'] = 'HH:ii';
            options['timeWheels'] = 'HHii';
          } else {
            options['timeFormat'] = 'h:ii A';
            options['timeWheels'] = 'hii A';
          }
          $(input).mobiscroll().datetime(options);
          return $(input).mobiscroll('show');
        }

        travelDayChanged(event) {
          var btn, cur, dIn, dOut, date, fullDateFormat, input, range, rangeD, rangeH, type;
          cur = $(event.currentTarget);
          type = cur.attr('data-type');
          fullDateFormat = 'MMMM Do YYYY ' + this.timeFormat;
          if (type === 'in') {
            input = this.$el.find('#id-input-travel-day-in');
            btn = this.$el.find('#id-btn-travel-day-in').find('.ui-btn-text');
            //# SET OUT PROV VALUE - NEXT DAY
            dOut = Moment(this.$el.find('#id-input-travel-day-in').val(), 'YYYY-MM-DD').add('d', 1);
            this.$el.find('#id-input-travel-day-out').val(dOut.format('YYYY-MM-DD'));
            this.$el.find('#id-btn-travel-day-out').find('.ui-btn-text').text(dOut.format(fullDateFormat));
          } else {
            input = this.$el.find('#id-input-travel-day-out');
            btn = this.$el.find('#id-btn-travel-day-out').find('.ui-btn-text');
          }
          date = input.val();
          btn.text(Moment(date).format(fullDateFormat));
          if (this.__check_correct_dates(this.$el.find('#id-input-travel-day-in').val(), this.$el.find('#id-input-travel-day-out').val())) {
            dIn = Moment(this.$el.find('#id-input-travel-day-in').val());
            dOut = Moment(this.$el.find('#id-input-travel-day-out').val());
            this.$el.find("#id-btn-travel-day-next").removeClass('ui-disabled');
            rangeD = dOut.diff(dIn, 'days') + ' day(s) ';
            rangeH = (dOut.diff(dIn, 'hours') % 24) + " hour(s)";
            range = rangeD + rangeH;
            this.$el.find('#id-span-travel-days-notification').show().text(range);
            return this.$el.find("#id-btn-travel-day-next").find('.ui-btn-text').text('Done');
          } else {
            this.$el.find("#id-btn-travel-day-next").find('.ui-btn-text').text('Invalid dates');
            if (!this.$el.find("#id-btn-travel-day-next").hasClass('ui-disabled')) {
              return this.$el.find("#id-btn-travel-day-next").addClass('ui-disabled');
            }
          }
        }

        btnTravelDayDoneClicked(event) {
          var dateIn, dateOut;
          event.stopPropagation();
          event.preventDefault();
          //headerHtml = @__generate_header_details_html(@timereport)
          dateIn = Moment(this.$el.find('#id-input-travel-day-in').val());
          dateOut = Moment(this.$el.find('#id-input-travel-day-out').val());
          if (dateOut.diff(dateIn, 'minutes') > 240) {
            this.$el.find('#id-div-travel-diem').show();
          }
          //INIT TIMEREPORT EXPENSE MODEL
          this.timereport.initialize_travel_expense(dateIn.format(this.dateTimeFormat), dateOut.format(this.dateTimeFormat));
          //# VERIFY CURRENT STATUS WITH SERVER
          this.timereport.validate_travel_expense(this.usr);
          $.mobile.loading('show');
          // @$el.find("#id-div-travel-header").html(headerHtml)
          this.$el.find('#id-div-wrap-dates').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          //SHOWING COMMIT TR BUTTOn
          return $('#id-btn-save-tr').show();
        }

        btnTravelHeaderClicked(event) {
          var sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          this.$el.find('#id-input-travel-day-in').val(sheet.startDateAndTime);
          this.$el.find('#id-btn-travel-day-in').find('.ui-btn-text').text(Moment(sheet.startDateAndTime).format('MMMM Do YYYY '));
          this.$el.find('#id-input-travel-day-out').val(sheet.stopDateAndTime);
          this.$el.find('#id-btn-travel-day-out').find('.ui-btn-text').text(Moment(sheet.stopDateAndTime).format('MMMM Do YYYY '));
          this.$el.find('#id-btn-travel-day-next').removeClass('ui-disabled');
          this.$el.find('#id-div-wrap-travel-expense').hide();
          return this.$el.find('#id-div-wrap-dates').show();
        }

        btnEditDestinationClicked(event) {
          event.stopPropagation();
          event.preventDefault();
          this.$el.find('#id-input-destination').val(this.timereport.get('Timereport').TravelExpenseSheet.destination);
          return this.$el.find('#id-div-wrap-input-destination').toggle();
        }

        btnDoneDestinationClicked(event) {
          var dest;
          event.stopPropagation();
          event.preventDefault();
          dest = this.$el.find('#id-input-destination').val();
          this.timereport.get('Timereport').TravelExpenseSheet.destination = dest;
          this.$el.find('#id-span-destination').text(dest);
          return this.$el.find('#id-div-wrap-input-destination').toggle();
        }

        btnEditNoteClicked(event) {
          event.stopPropagation();
          event.preventDefault();
          this.$el.find('#id-textarea-note').val(this.timereport.get('Timereport').TravelExpenseSheet.note);
          return this.$el.find('#id-div-wrap-input-note').toggle();
        }

        btnDoneNoteClicked(event) {
          var note;
          event.stopPropagation();
          event.preventDefault();
          note = this.$el.find('#id-textarea-note').val();
          this.timereport.get('Timereport').TravelExpenseSheet.note = note;
          //@$el.find('#id-span-note').text(note)
          $.mobile.loading('show');
          return this.timereport.validate_travel_expense(this.usr);
        }

        //@$el.find('#id-div-wrap-input-note').toggle()
        btnDiemClicked(event) {
          var btn, sheet, status, usePerDiem;
          if (event != null) {
            event.stopPropagation();
          }
          if (event != null) {
            event.preventDefault();
          }
          btn = $(event.currentTarget);
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          if (!status) {
            status = btn.attr('data-status');
          }
          if (status === 'off') {
            btn.find('.ui-btn-text').text('Yes');
            btn.attr('data-status', 'on');
            btn.removeClass('btn-no').addClass('btn-yes');
            this.$el.find('.row-per-diem').show();
            //#SET PER DIEM TOTAL
            this.$el.find('#id-p-diem-total').text("PER DIEM TOTAL " + sheet.perDiemTotal);
            usePerDiem = 1;
          } else {
            btn.find('.ui-btn-text').text('No');
            btn.attr('data-status', 'off');
            btn.removeClass('btn-yes').addClass('btn-no');
            this.$el.find('.row-per-diem').hide();
            usePerDiem = 0;
          }
          sheet.usePerDiem = usePerDiem;
          $.mobile.loading('show');
          return this.timereport.validate_travel_expense(this.usr);
        }

        btnAbroadClicked(event) {
          var abroad, btn, sheet, status;
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          event.stopPropagation();
          event.preventDefault();
          btn = $(event.currentTarget);
          status = btn.attr('data-status');
          if (status === 'off') {
            btn.find('.ui-btn-text').text('Yes');
            btn.attr('data-status', 'on');
            btn.removeClass('btn-no').addClass('btn-yes');
            abroad = 1;
          } else {
            btn.find('.ui-btn-text').text('No');
            btn.attr('data-status', 'off');
            btn.removeClass('btn-yes').addClass('btn-no');
            abroad = 0;
          }
          sheet.abroad = abroad;
          $.mobile.loading('show');
          return this.timereport.validate_travel_expense(this.usr);
        }

        btnQuantityClicked(event) {
          var btn, quant, sign, type;
          event.stopPropagation();
          event.preventDefault();
          btn = $(event.currentTarget);
          sign = btn.attr('data-sign');
          type = btn.attr('data-type');
          quant = parseInt(btn.attr('data-quantity'), 10);
          if (quant === 0 && sign === '-') {
            return;
          } else {
            if (sign === '+') {
              quant += 1;
            } else {
              quant -= 1;
            }
          }
          //btn.attr('data-quantity',quant)
          $.mobile.loading('show');
          return this.timereport.set_travel_per_diem(this.usr, type, quant);
        }

        btnAddNewDrive(event, isOld) {
          event.stopPropagation();
          event.preventDefault();
          if (!isOld) {
            this.$el.find("#id-input-drive-from").val("");
            this.$el.find("#id-input-drive-to").val("");
            this.$el.find("#id-input-drive-km").val("");
            this.$el.find("#id-input-drive-cpr").val("");
            this.$el.find("#id-input-drive-plate").val("");
            this.__change_button_status(this.$el.find("#id-btn-drive-own-car"), 1);
            this.$el.find('#id-textarea-drive-note').val("");
            this.$el.find('#id-btn-save-drive').attr('data-driveID', "");
            this.$el.find('#id-btn-delete-drive').hide();
          } else {
            this.$el.find('#id-btn-delete-drive').show();
          }
          this.$el.find('#id-div-form-drive').show();
          this.$el.find('#id-div-wrap-travel-expense').hide();
          return $('#id-btn-save-tr').hide();
        }

        btnSaveDrive(event) {
          var drive, driveID, sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          driveID = $(event.currentTarget).attr('data-driveID');
          if (!driveID) {
            drive = {
              driveID: ""
            };
            if (!sheet.Drive) {
              sheet.Drive = [];
            }
            //# DIRTY UGLY WAY OF KEEPING ALWAYS AN ARRAY in EXPENSES
            if (!_.isArray(sheet.Drive)) {
              sheet.Drive = [sheet.Drive];
            }
            sheet.Drive.push(drive);
          } else {
            drive = _.findWhere(sheet.Drive, {
              driveID: driveID
            });
          }
          drive.from = this.$el.find("#id-input-drive-from").val();
          drive.to = this.$el.find("#id-input-drive-to").val();
          drive.km = this.$el.find("#id-input-drive-km").val();
          sheet.cpr = this.$el.find("#id-input-drive-cpr").val();
          drive.numberplate = this.$el.find("#id-input-drive-plate").val();
          drive.note = this.$el.find('#id-textarea-drive-note').val();
          if (this.$el.find("#id-btn-drive-own-car").attr('data-status') === 'on') {
            drive.ownCar = 1;
          } else {
            drive.ownCar = 0;
          }
          $.mobile.loading('show');
          this.timereport.validate_travel_expense(this.usr);
          this.$el.find('#id-div-form-drive').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          return $('#id-btn-save-tr').show();
        }

        btnDeleteDrive(event) {
          var driveID, i, sheet;
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          driveID = $(event.currentTarget).attr('data-driveID');
          i = 0;
          _.each(sheet.Drive, function(d) {
            if (d.driveID === driveID) {
              sheet.Drive.splice(i, 1);
            }
            return i++;
          });
          $.mobile.loading('show');
          this.timereport.validate_travel_expense(this.usr);
          this.$el.find('#id-div-form-drive').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          return $('#id-btn-save-tr').show();
        }

        btnAddNewCash(event, isOld) {
          event.stopPropagation();
          event.preventDefault();
          if (!isOld) {
            this.$el.find("#id-input-cash-amount").val("");
            this.$el.find("#id-select-cash-currency").val(this.defaultCurrency).selectmenu('refresh');
            this.__change_button_status(this.$el.find("#id-btn-cash-card"), 0);
            this.$el.find("#id-input-cash-returned").val("");
            this.$el.find('#id-textarea-cash-note').val("");
            this.$el.find('#id-btn-save-cash').attr('data-cashAdvanceID', "");
            this.$el.find('#id-btn-delete-cash').hide();
          } else {
            this.$el.find('#id-btn-delete-cash').show();
          }
          this.$el.find('#id-div-form-cash').show();
          this.$el.find('#id-div-wrap-travel-expense').hide();
          return $('#id-btn-save-tr').hide();
        }

        btnSaveCash(event) {
          var cash, cashID, sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          cashID = $(event.currentTarget).attr('data-cashAdvanceID');
          if (!cashID) {
            cash = {
              cashID: ""
            };
            if (!sheet.CashAdvance) {
              sheet.CashAdvance = [];
            }
            //# DIRTY UGLY WAY OF KEEPING ALWAYS AN ARRAY in EXPENSES
            if (!_.isArray(sheet.CashAdvance)) {
              sheet.CashAdvance = [sheet.CashAdvance];
            }
            sheet.CashAdvance.push(cash);
          } else {
            cash = _.findWhere(sheet.CashAdvance, {
              cashAdvanceID: cashID
            });
          }
          cash.amount = this.$el.find("#id-input-cash-amount").val();
          cash.currency = this.$el.find("#id-select-cash-currency").val();
          cash.amountReturned = this.$el.find("#id-input-cash-returned").val();
          cash.note = this.$el.find('#id-textarea-cash-note').val();
          if (this.$el.find("#id-btn-cash-card").attr('data-status') === 'on') {
            cash.fromCard = 1;
          } else {
            cash.fromCard = 0;
          }
          $.mobile.loading('show');
          this.timereport.validate_travel_expense(this.usr);
          this.$el.find('#id-div-form-cash').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          return $('#id-btn-save-tr').show();
        }

        btnDeleteCash(event) {
          var cashID, i, sheet;
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          cashID = $(event.currentTarget).attr('data-cashAdvanceID');
          i = 0;
          _.each(sheet.CashAdvance, function(d) {
            if (d.cashAdvanceID === cashID) {
              delete sheet.CashAdvance.splice(i, 1);
            }
            return i++;
          });
          $.mobile.loading('show');
          this.timereport.validate_travel_expense(this.usr);
          this.$el.find('#id-div-form-cash').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          return $('#id-btn-save-tr').show();
        }

        btnAddNewExpense(event, isOld) {
          event.stopPropagation();
          event.preventDefault();
          if (!isOld) {
            this.$el.find("#id-input-expense-amount").val("");
            this.$el.find("#id-select-expense-currency").val(this.defaultCurrency).selectmenu('refresh');
            this.$el.find('#id-input-expense-ref-number').val("");
            this.__change_button_status(this.$el.find("#id-btn-expense-paid-card"), 0);
            this.$el.find("#id-textarea-expense-note").val("");
            this.$el.find('#id-btn-save-expense').attr('data-expenseID', "");
            this.$el.find('#id-btn-delete-expense').hide();
            this.$el.find('#id-a-thumbnail').html('<span class="fwi-image"/> ');
          } else {
            this.$el.find('#id-btn-delete-expense').show();
          }
          this.$el.find('#id-div-form-expense').show();
          this.$el.find('#id-div-wrap-travel-expense').hide();
          return $('#id-btn-save-tr').hide();
        }

        btnSaveExpense(event) {
          var exp, expenseID, sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          expenseID = $(event.currentTarget).attr('data-expenseID');
          if (!expenseID) {
            exp = {
              expenseID: ""
            };
            //# DIRTY UGLY WAY OF KEEPING ALWAYS AN ARRAY in EXPENSES
            if (!sheet.Expense) {
              sheet.Expense = [];
            }
            if (!_.isArray(sheet.Expense)) {
              sheet.Expense = [sheet.Expense];
            }
            // WAS = > IF NEW EXPENSE WE MANUALLY ADD THE IMAGEDATA  (IF EXISTS)
            //        img = $("#id-a-thumbnail").find('img')
            //        if img.length is 1
            //          raw = img.attr('src').split(',')
            //          exp['imagedata']   = raw[1]
            sheet.Expense.push(exp);
          } else {
            exp = _.findWhere(sheet.Expense, {
              expenseID: expenseID
            });
          }
          exp.amount = this.$el.find("#id-input-expense-amount").val();
          exp.currency = this.$el.find("#id-select-expense-currency").val();
          exp.type = this.$el.find("#id-select-expense-type").val();
          exp.number = this.$el.find('#id-input-expense-ref-number').val();
          if (this.$el.find("#id-btn-expense-paid-card").attr('data-status') === 'on') {
            exp.cardPayment = 1;
          } else {
            exp.cardPayment = 0;
          }
          exp.note = this.$el.find("#id-textarea-expense-note").val();
          $.mobile.loading('show');
          this.timereport.validate_travel_expense(this.usr);
          this.$el.find('#id-div-form-expense').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          return $('#id-btn-save-tr').show();
        }

        btnDeleteExpense(event) {
          var expenseID, i, sheet;
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          expenseID = $(event.currentTarget).attr('data-expenseID');
          i = 0;
          _.each(sheet.Expense, function(d) {
            if (d.expenseID === expenseID) {
              delete sheet.Expense.splice(i, 1);
            }
            return i++;
          });
          window.expense[expenseID] = null;
          $.mobile.loading('show');
          this.timereport.validate_travel_expense(this.usr);
          this.$el.find('#id-div-form-expense').hide();
          this.$el.find('#id-div-wrap-travel-expense').show();
          return $('#id-btn-save-tr').show();
        }

        btnUploadImageExpense(event) {
          var expense, expenseID, img, reader, sheet;
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          expenseID = this.$el.find('#id-btn-save-expense').attr('data-expenseID');
          expense = _.findWhere(sheet.Expense, {
            expenseID: expenseID
          });
          img = event.target.files[0];
          reader = new FileReader();
          reader.onload = function(img) {
            if (expense) {
              //expense['imagedata'+expense.expenseID] = img.target.result.split(',')[1]
              window.expense[expense.expenseID] = img.target.result;
            } else {
              window.expense['imageFileData'] = img.target.result;
            }
            return $("#id-a-thumbnail").html('<img src="' + img.target.result + '" width="50px" height="50px">');
          };
          // Read in the image file as a data URL.
          return reader.readAsDataURL(img);
        }

        btnThumbnailClicked(event) {
          var popup, src;
          event.stopPropagation();
          event.preventDefault();
          src = $(event.currentTarget).find('img').attr('src');
          popup = $('#popupimage');
          popup.html('<img src="' + src + '">');
          return popup.popup('open');
        }

        btnDeleteThumbnailClicked(event) {
          var expenseID, i, sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          expenseID = this.$el.find('#id-btn-delete-expense').attr('data-expenseID');
          this.$el.find('#id-a-thumbnail img').attr('src', '');
          i = 0;
          _.each(sheet.Expense, function(d) {
            if (d.expenseID === expenseID) {
              d.imageFileName = "";
              d.imageFileData = "";
            }
            return i++;
          });
          return window.expense[expenseID] = null;
        }

        trDriveClicked(event) {
          var drive, driveID, sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          driveID = $(event.currentTarget).attr('data-driveID');
          if (sheet.Drive && !_.isArray(sheet.Drive)) {
            sheet.Drive = [sheet.Drive];
          }
          drive = _.findWhere(sheet.Drive, {
            driveID: driveID
          });
          this.$el.find('#id-btn-save-drive').attr('data-driveID', driveID);
          this.$el.find('#id-btn-delete-drive').attr('data-driveID', driveID);
          this.$el.find("#id-input-drive-from").val(drive.from);
          this.$el.find("#id-input-drive-to").val(drive.to);
          this.$el.find("#id-input-drive-km").val(drive.km);
          this.$el.find("#id-input-drive-cpr").val(sheet.cpr);
          this.$el.find("#id-input-drive-plate").val(drive.numberplate);
          this.__change_button_status(this.$el.find("#id-btn-drive-own-car"), drive.ownCar);
          this.$el.find('#id-textarea-drive-note').val(drive.note);
          return this.btnAddNewDrive(event, true);
        }

        trCashAdvanceClicked(event) {
          var cash, cashID, sheet;
          event.stopPropagation();
          event.preventDefault();
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          cashID = $(event.currentTarget).attr('data-cashAdvanceID');
          if (sheet.CashAdvance && !_.isArray(sheet.CashAdvance)) {
            sheet.CashAdvance = [sheet.CashAdvance];
          }
          cash = _.findWhere(sheet.CashAdvance, {
            cashAdvanceID: cashID
          });
          this.$el.find('#id-btn-save-cash').attr('data-cashAdvanceID', cashID);
          this.$el.find('#id-btn-delete-cash').attr('data-cashAdvanceID', cashID);
          this.$el.find("#id-input-cash-amount").val(cash.amount);
          this.$el.find("#id-select-cash-currency").val(cash.currency).selectmenu('refresh');
          this.__change_button_status(this.$el.find("#id-btn-cash-card"), cash.fromCard);
          this.$el.find("#id-input-cash-returned").val(cash.amountReturned);
          this.$el.find('#id-textarea-cash-note').val(cash.note);
          return this.btnAddNewCash(event, true);
        }

        trExpenseClicked(event) {
          var exp, expenseID, img, sheet;
          event.stopPropagation();
          event.preventDefault();
          $("#id-input-file-expense").val('');
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          expenseID = $(event.currentTarget).attr('data-expenseID');
          if (sheet.Expense && !_.isArray(sheet.Expense)) {
            sheet.Expense = [sheet.Expense];
          }
          exp = _.findWhere(sheet.Expense, {
            expenseID: expenseID
          });
          this.$el.find('#id-btn-save-expense').attr('data-expenseID', expenseID);
          this.$el.find('#id-btn-delete-expense').attr('data-expenseID', expenseID);
          this.$el.find("#id-input-expense-amount").val(exp.amount);
          this.$el.find("#id-select-expense-currency").val(exp.currency).selectmenu('refresh');
          this.$el.find("#id-select-expense-type").val(exp.type).selectmenu('refresh');
          this.$el.find('#id-input-expense-ref-number').val(exp.number);
          this.__change_button_status(this.$el.find("#id-btn-expense-paid-card"), exp.cardPayment);
          this.$el.find("#id-textarea-expense-note").val(exp.note);
          if (!(exp.imageFileData ? img = exp.imageFileData : img = exp['imagedata' + expenseID])) {
            // COFFESCRIPT LOVE LINE  => Getting Image Value from 3 different states of Timereport (Just clicked, modified, newly created) :-D
            img = window.expense[expenseID];
          }
          if (img) {
            this.$el.find("#id-a-thumbnail").html('<img src="' + img + '" width="50px" height="50px">');
            this.$el.find("#id-delete-thumbnail").show();
          } else {
            this.$el.find("#id-a-thumbnail").html('<span class="fwi-image"/>');
          }
          return this.btnAddNewExpense(event, true);
        }

        __filled_timereport() {
          var headerHtml, sheet, showDateSelector;
          $.mobile.loading('hide');
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          if (sheet) {
            if (window.expense.previousAllowPerDiem === 0 && (sheet != null ? sheet.allowPerDiem : void 0) === 1) {
              sheet.usePerDiem = this.usr.get('travelExpensesAutoSelectPerDiemWhenAllowed');
              this.timereport.validate_travel_expense(this.usr);
            }
            window.expense.previousAllowPerDiem = sheet.allowPerDiem;
            showDateSelector = sheet.totalTime === "";
            _.each(sheet.Expense, function(e) {
              var newImg;
              if (!(e.expenseID in window.expense)) {
                newImg = false;
                if (window.expense['imageFileData']) {
                  newImg = window.expense['imageFileData'];
                }
                return window.expense[e.expenseID] = newImg;
              }
            });
            window.expense['imageFileData'] = null;
          } else {
            showDateSelector = true;
          }
          if (showDateSelector) {
            this.$el.find('#id-div-wrap-travel-expense').hide();
            this.$el.find('#id-div-wrap-dates').show();
          } else {
            this.$el.find("#id-div-travel-header").empty();
            headerHtml = this.__generate_header_details_html(this.timereport);
            this.$el.find("#id-div-travel-header").html(headerHtml);
            this.__init_travel_expenses();
            this.$el.find('#id-div-wrap-travel-expense').show();
            this.$el.find('#id-div-wrap-dates').hide();
          }
          return $('#divTimeReportTravel').trigger('create');
        }

        __change_button_status(btn, status) {
          if ((btn != null ? btn.type : void 0) === 'tap') {
            btn = $(btn.currentTarget);
            if (btn.attr('data-status') === 'off') {
              status = 1;
            } else {
              status = null;
            }
          }
          if (status) {
            btn.find('.ui-btn-text').text('Yes');
            btn.attr('data-status', 'on');
            return btn.removeClass('btn-no').addClass('btn-yes');
          } else {
            btn.find('.ui-btn-text').text('No');
            btn.attr('data-status', 'off');
            return btn.removeClass('btn-yes').addClass('btn-no');
          }
        }

        __init_travel_expenses() {
          var btn, btnAbroad, sheet;
          btn = this.$el.find('#id-btn-diem');
          btnAbroad = this.$el.find('#id-btn-abroad');
          if (!btn.find('.ui-btn-text')) {
            btn.button();
          }
          sheet = this.timereport.get('Timereport').TravelExpenseSheet;
          if (sheet.allowPerDiem) {
            this.$el.find('#id-div-travel-diem').show();
          } else {
            this.$el.find('#id-div-travel-diem').hide();
          }
          this.__change_button_status(btn, sheet.usePerDiem);
          this.__change_button_status(btnAbroad, sheet.abroad);
          //#SET QUANTITIES
          this.$el.find('#id-p-quantity-breakfast').html(sheet.breakfastDays);
          this.$el.find('#id-btn-quantity-minus-breakfast').attr('data-quantity', sheet.breakfastDays);
          this.$el.find('#id-btn-quantity-plus-breakfast').attr('data-quantity', sheet.breakfastDays);
          this.$el.find('#id-p-quantity-lunch').text(sheet.lunchDays);
          this.$el.find('#id-btn-quantity-minus-lunch').attr('data-quantity', sheet.lunchDays);
          this.$el.find('#id-btn-quantity-plus-lunch').attr('data-quantity', sheet.lunchDays);
          this.$el.find('#id-p-quantity-dinner').text(sheet.dinnerDays);
          this.$el.find('#id-btn-quantity-minus-dinner').attr('data-quantity', sheet.dinnerDays);
          this.$el.find('#id-btn-quantity-plus-dinner').attr('data-quantity', sheet.dinnerDays);
          //#SET PER DIEM TOTAL
          this.$el.find('#id-p-diem-total').html("PER DIEM TOTAL &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + sheet.perDiemTotal);
          //# Set Travel Distance
          if (sheet.Drive) {
            this.__set_current_drives(sheet.Drive);
          }
          if (sheet.CashAdvance) {
            this.__set_current_cashAdvances(sheet.CashAdvance);
          }
          if (sheet.Expense) {
            this.__set_current_expenses(sheet.Expense);
          }
          // SHOW
          if (sheet.usePerDiem) {
            this.$el.find('.row-per-diem').show();
          } else {
            this.$el.find('.row-per-diem').hide();
          }
          //SET FOOTER
          this.$el.find('#id-p-overall-total').html(`TOTAL ${this.defaultCurrency} &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ${sheet.total}`).show();
          return this.$el.find('#id-p-status-footer').html(`STATUS ${sheet.status} &bull; NUMBER ${sheet.number}`).show();
        }

        __set_current_drives(drives) {
          var tbl;
          if (!drives) {
            drives = this.timereport.get('Timereport').TravelExpenseSheet.Drive;
          }
          if (!_.isArray(drives)) {
            drives = [drives];
          }
          if (drives.length > 0) {
            tbl = '<table id="id-table-drives" class="table-travel-timereport"><thead><tr><th colspan="2">TRAVELED DISTANCE</th></tr></thead>';
            _.each(drives, (drive) => {
              var tds, tr;
              tr = `<tr data-driveID=\"${drive.driveID}\" class='trDrive'>`;
              tds = `<td><span style='float: right;' class='span-travel-total'>${drive.km} KM</span><p><span class='span-from'>From:</span> ${drive.from}</p><p><span class='span-from'>To:</span> ${drive.to}</p></td>`;
              tds += `<td class='td-total'>${drive.total}</td>`;
              tr += tds + '</tr>';
              return tbl += tr;
            });
            tbl += '</table>';
            //#SET TRAVELED TOTAL
            tbl += "<p class='p-travel-totals'>TRAVELED DISTANCE TOTAL &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.timereport.get('Timereport').TravelExpenseSheet.drivingTotal + "</p>";
            this.$el.find('#id-div-travel-distance').html(tbl);
            return this.$el.find('#id-div-travel-distance').show();
          }
        }

        __set_current_cashAdvances(advances) {
          var tbl;
          if (!advances) {
            advances = this.timereport.get('Timereport').TravelExpenseSheet.CashAdvance;
          }
          if (!_.isArray(advances)) {
            advances = [advances];
          }
          if (advances.length > 0) {
            tbl = '<table id="id-table-advances" class="table-travel-timereport"><thead><tr><th colspan="2">CASH ADVANCES</th></tr></thead>';
            _.each(advances, (cash) => {
              var tds, tr;
              tr = `<tr data-cashAdvanceID=\"${cash.cashAdvanceID}\" class='trCashAdvance'>`;
              tds = "<td><p class='p-align-right'>Cash</p></td>";
              tds += `<td class='td-total'>${cash.amount}</td>`;
              tr += tds + '</tr>';
              return tbl += tr;
            });
            tbl += '</table>';
            //#SET TRAVELED TOTAL
            tbl += "<p class='p-travel-totals'>CASH ADVANCE TOTAL &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.timereport.get('Timereport').TravelExpenseSheet.cashAdvancesTotal + "</p>";
            this.$el.find('#id-div-travel-cash-advance').html(tbl);
            return this.$el.find('#id-div-travel-cash-advance').show();
          }
        }

        __set_current_expenses(expenses) {
          var tbl;
          if (!expenses) {
            expenses = this.timereport.get('Timereport').TravelExpenseSheet.Expense;
          }
          if (!_.isArray(expenses)) {
            expenses = [expenses];
          }
          if (expenses.length > 0) {
            tbl = '<table id="id-table-expenses" class="table-travel-timereport"><thead><tr><th colspan="2">EXPENSES</th></tr></thead>';
            _.each(expenses, (exp) => {
              var tds, tr;
              tr = `<tr data-expenseID=\"${exp.expenseID}\" class='trExpense'>`;
              tds = `<td><p class='p-align-right'>${exp.type}</p></td>`;
              tds += `<td class='td-total'>${exp.amount}</td>`;
              tr += tds + '</tr>';
              return tbl += tr;
            });
            tbl += '</table>';
            //#SET TRAVELED TOTAL
            tbl += "<p class='p-travel-totals'>EXPENSES TOTAL &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.timereport.get('Timereport').TravelExpenseSheet.expensesTotal + "</p>";
            this.$el.find('#id-div-travel-expense').html(tbl);
            return this.$el.find('#id-div-travel-expense').show();
          }
        }

        __generate_header_details_html(mdl) {
          var dIn, dOut, dateIn, dateOut, destination, headerHTML, note, range, rangeD, rangeH;
          dIn = this.$el.find('#id-input-travel-day-in').val();
          dOut = this.$el.find('#id-input-travel-day-out').val();
          if (dIn.length > 0) {
            dateIn = Moment(dIn);
          } else {
            dateIn = Moment(mdl.get('Timereport').TravelExpenseSheet.startDateAndTime);
          }
          if (dOut.length > 0) {
            dateOut = Moment(dOut);
          } else {
            dateOut = Moment(mdl.get('Timereport').TravelExpenseSheet.stopDateAndTime);
          }
          destination = "Tap to add a Destination";
          note = "Tap to add a Note";
          if (mdl.get('Timereport').TravelExpenseSheet.note !== "") {
            note = mdl.get('Timereport').TravelExpenseSheet.note;
          }
          if (mdl.get('Timereport').TravelExpenseSheet.destination !== "") {
            destination = mdl.get('Timereport').TravelExpenseSheet.destination;
          }
          rangeD = dateOut.diff(dateIn, 'days') + ' day(s) ';
          rangeH = (dateOut.diff(dateIn, 'hours') % 24) + " hour(s)";
          range = rangeD + rangeH;
          headerHTML = '<div class="ui-block-a time" >';
          headerHTML += `<p id='id-div-timeIn' class='travel-time-header'>${dateIn.format(this.timeFormat)}</p> <p id='id-div-timeOut' class='travel-time-header'>${dateOut.format(this.timeFormat)}</p>`;
          headerHTML += "</div>";
          headerHTML += '<div class="ui-block-b info">';
          headerHTML += `<p class='main-date'><strong>${dateIn.format('dddd Do MMMM')}</strong></p> <p class='year'><small>${dateIn.format('YYYY')}</small></p> <p class='human-date'><small>${range}</small></p>`;
          headerHTML += "</div>";
          headerHTML += "<div class='ui-block-a div-label edit-destination'><p>Destination</p></div>";
          headerHTML += `<div class='ui-block-b div-info edit-destination'><p><span class='fwi-edit' style='float: right;'/><span id='id-span-destination'>${destination}</span></p></div>`;
          headerHTML += "<div id='id-div-wrap-input-destination' class='div-wrap-input-header' style='display: none;'><input type='text' id='id-input-destination' ><a href='#' id='id-btn-done-destination' class='btn-done-note'>Done</a></div>";
          headerHTML += "<div class='ui-block-a div-label edit-note'><p>Note</p></div>";
          headerHTML += `<div class='ui-block-b div-info edit-note'><p><span class='fwi-edit' style='float: right;'/><span id='id-span-note'>${note}</span></p></div>`;
          return headerHTML += "<div id='id-div-wrap-input-note' class='div-wrap-input-header' style='display: none;'><textarea id='id-textarea-note' /><a href='#' id='id-btn-done-note' class='btn-done-note'>Done</a></div>";
        }

        __check_correct_dates(dIn, dOut) {
          var correct;
          correct = false;
          if (Moment(dIn) < Moment(dOut)) {
            correct = true;
          }
          return correct;
        }

      };

      TimereportTravelExpenseView.prototype.className = 'subTimeReportDetailView';

      return TimereportTravelExpenseView;

    }).call(this);
  });

}).call(this);
